using System;
using System.Collections.Generic;
using Android.Runtime;
using Java.Interop;

namespace CN.Pda.Serialport {

	// Metadata.xml XPath class reference: path="/api/package[@name='cn.pda.serialport']/class[@name='Tools']"
	[global::Android.Runtime.Register ("cn/pda/serialport/Tools", DoNotGenerateAcw=true)]
	public partial class Tools : global::Java.Lang.Object {
		static readonly JniPeerMembers _members = new XAPeerMembers ("cn/pda/serialport/Tools", typeof (Tools));

		internal static IntPtr class_ref {
			get { return _members.JniPeerType.PeerReference.Handle; }
		}

		[global::System.Diagnostics.DebuggerBrowsable (global::System.Diagnostics.DebuggerBrowsableState.Never)]
		[global::System.ComponentModel.EditorBrowsable (global::System.ComponentModel.EditorBrowsableState.Never)]
		public override global::Java.Interop.JniPeerMembers JniPeerMembers {
			get { return _members; }
		}

		[global::System.Diagnostics.DebuggerBrowsable (global::System.Diagnostics.DebuggerBrowsableState.Never)]
		[global::System.ComponentModel.EditorBrowsable (global::System.ComponentModel.EditorBrowsableState.Never)]
		protected override IntPtr ThresholdClass {
			get { return _members.JniPeerType.PeerReference.Handle; }
		}

		[global::System.Diagnostics.DebuggerBrowsable (global::System.Diagnostics.DebuggerBrowsableState.Never)]
		[global::System.ComponentModel.EditorBrowsable (global::System.ComponentModel.EditorBrowsableState.Never)]
		protected override global::System.Type ThresholdType {
			get { return _members.ManagedPeerType; }
		}

		protected Tools (IntPtr javaReference, JniHandleOwnership transfer) : base (javaReference, transfer)
		{
		}

		// Metadata.xml XPath constructor reference: path="/api/package[@name='cn.pda.serialport']/class[@name='Tools']/constructor[@name='Tools' and count(parameter)=0]"
		[Register (".ctor", "()V", "")]
		public unsafe Tools () : base (IntPtr.Zero, JniHandleOwnership.DoNotTransfer)
		{
			const string __id = "()V";

			if (((global::Java.Lang.Object) this).Handle != IntPtr.Zero)
				return;

			try {
				var __r = _members.InstanceMethods.StartCreateInstance (__id, ((object) this).GetType (), null);
				SetHandle (__r.Handle, JniHandleOwnership.TransferLocalRef);
				_members.InstanceMethods.FinishCreateInstance (__id, this, null);
			} finally {
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='cn.pda.serialport']/class[@name='Tools']/method[@name='Bytes2HexString' and count(parameter)=2 and parameter[1][@type='byte[]'] and parameter[2][@type='int']]"
		[Register ("Bytes2HexString", "([BI)Ljava/lang/String;", "")]
		public static unsafe string Bytes2HexString (byte[] b, int size)
		{
			const string __id = "Bytes2HexString.([BI)Ljava/lang/String;";
			IntPtr native_b = JNIEnv.NewArray (b);
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [2];
				__args [0] = new JniArgumentValue (native_b);
				__args [1] = new JniArgumentValue (size);
				var __rm = _members.StaticMethods.InvokeObjectMethod (__id, __args);
				return JNIEnv.GetString (__rm.Handle, JniHandleOwnership.TransferLocalRef);
			} finally {
				if (b != null) {
					JNIEnv.CopyArray (native_b, b);
					JNIEnv.DeleteLocalRef (native_b);
				}
				global::System.GC.KeepAlive (b);
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='cn.pda.serialport']/class[@name='Tools']/method[@name='HexString2Bytes' and count(parameter)=1 and parameter[1][@type='java.lang.String']]"
		[Register ("HexString2Bytes", "(Ljava/lang/String;)[B", "")]
		public static unsafe byte[] HexString2Bytes (string src)
		{
			const string __id = "HexString2Bytes.(Ljava/lang/String;)[B";
			IntPtr native_src = JNIEnv.NewString (src);
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [1];
				__args [0] = new JniArgumentValue (native_src);
				var __rm = _members.StaticMethods.InvokeObjectMethod (__id, __args);
				return (byte[]) JNIEnv.GetArray (__rm.Handle, JniHandleOwnership.TransferLocalRef, typeof (byte));
			} finally {
				JNIEnv.DeleteLocalRef (native_src);
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='cn.pda.serialport']/class[@name='Tools']/method[@name='bytesToInt' and count(parameter)=1 and parameter[1][@type='byte[]']]"
		[Register ("bytesToInt", "([B)I", "")]
		public static unsafe int BytesToInt (byte[] bytes)
		{
			const string __id = "bytesToInt.([B)I";
			IntPtr native_bytes = JNIEnv.NewArray (bytes);
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [1];
				__args [0] = new JniArgumentValue (native_bytes);
				var __rm = _members.StaticMethods.InvokeInt32Method (__id, __args);
				return __rm;
			} finally {
				if (bytes != null) {
					JNIEnv.CopyArray (native_bytes, bytes);
					JNIEnv.DeleteLocalRef (native_bytes);
				}
				global::System.GC.KeepAlive (bytes);
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='cn.pda.serialport']/class[@name='Tools']/method[@name='getmyTime' and count(parameter)=0]"
		[Register ("getmyTime", "()Ljava/lang/String;", "")]
		public static unsafe string GetmyTime ()
		{
			const string __id = "getmyTime.()Ljava/lang/String;";
			try {
				var __rm = _members.StaticMethods.InvokeObjectMethod (__id, null);
				return JNIEnv.GetString (__rm.Handle, JniHandleOwnership.TransferLocalRef);
			} finally {
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='cn.pda.serialport']/class[@name='Tools']/method[@name='intToByte' and count(parameter)=1 and parameter[1][@type='int']]"
		[Register ("intToByte", "(I)[B", "")]
		public static unsafe byte[] IntToByte (int i)
		{
			const string __id = "intToByte.(I)[B";
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [1];
				__args [0] = new JniArgumentValue (i);
				var __rm = _members.StaticMethods.InvokeObjectMethod (__id, __args);
				return (byte[]) JNIEnv.GetArray (__rm.Handle, JniHandleOwnership.TransferLocalRef, typeof (byte));
			} finally {
			}
		}

		// Metadata.xml XPath method reference: path="/api/package[@name='cn.pda.serialport']/class[@name='Tools']/method[@name='uniteBytes' and count(parameter)=2 and parameter[1][@type='byte'] and parameter[2][@type='byte']]"
		[Register ("uniteBytes", "(BB)B", "")]
		public static unsafe sbyte UniteBytes (sbyte src0, sbyte src1)
		{
			const string __id = "uniteBytes.(BB)B";
			try {
				JniArgumentValue* __args = stackalloc JniArgumentValue [2];
				__args [0] = new JniArgumentValue (src0);
				__args [1] = new JniArgumentValue (src1);
				var __rm = _members.StaticMethods.InvokeSByteMethod (__id, __args);
				return __rm;
			} finally {
			}
		}

	}
}
